<?php

namespace App\Models\Procurement;
use App\Models\User;
use App\Models\People\Supplier;
use App\Models\Currency;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class Bid extends Model
{
    use HasFactory,softDeletes;
    public $guarded = ['id'];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($bid) {
            $bid->bid_no = static::generatBidNo($bid->request_for_quotation_id);
        });
    }
    private static function generatBidNo($request_for_quotation_id)
    {
        $date = now()->format('Ymd');

        return DB::transaction(function () use ($request_for_quotation_id) {
            // Use row-level locking to prevent race conditions
            $last_bn = static::where('request_for_quotation_id', $request_for_quotation_id)
            ->lockForUpdate()->orderBy('id', 'desc')->first();
            $number = $last_bn ? intval(substr($last_bn->bid_no, -4)) + 1 : 1;

            return 'BD'. $request_for_quotation_id. '-'. str_pad($number, 6, '0', STR_PAD_LEFT); //$date .  whereDate('created_at', today())
        });
    }
   
    public function bid_items()
    {
        return $this->hasMany(BidItem::class);
    }
    public function request_for_quotation()
    {
        return $this->belongsTo(RequestForQuotation::class);
    }
    
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }
    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
    public function evaluations()
    {
        return $this->HasMany(Evaluation::class);
    }
   
}
