<?php

namespace App\Models\Procurement;
use App\Models\User;
use App\Models\Accounting\Currency;
use App\Models\Procurement\Inventory\BitItem;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class BidItem extends Model
{
    use HasFactory,softDeletes;
    public $guarded = ['id'];

    public function bid()
    {
        return $this->belongsTo(BidItem::class);
    }
    public function evaluations()
    {
        return $this->hasMany(Evaluation::class);
    }
    public function request_for_quotation_item()
    {
        return $this->belongsTo(RequestForQuotationItem::class);
    }
    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
   
}
