<?php
namespace App\Models\Procurement;
use App\Models\People\Truck;
use App\Models\People\Driver;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;
class Grn extends Model
{
    use HasFactory,softDeletes;

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($grn) {
            $grn->grn_no = static::generateGrnNo($grn->organisation_id);
        });
       
    }
    private static function generateGrnNo($org_id)
    {
       
        return DB::transaction(function () use ($org_id){
            // Use row-level locking to prevent race conditions
            $lastgrn = static::where('organisation_id', $org_id)->lockForUpdate()->orderBy('id', 'desc')->first();
        
            // Generate a random number based on the current timestamp
            $randomNumber = substr(time(), -4);
        
            // Combine with a prefix and the random number
            return 'GRN' . $randomNumber;
        });
    }
    /**
     * Grn has many Items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function grn_items()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = grn_id, localKey = id)
        return $this->hasMany(GrnItem::class);
    }

    /**
     * Grn belongs to Po.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function purchase_order()
    {
        // belongsTo(RelatedModel, foreignKey = po_id, keyOnRelatedModel = id)
        return $this->belongsTo(PurchaseOrder::class);
    }

    /**
     * Grn belongs to Supplier.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function trucks()
    {
        // belongsTo(RelatedModel, foreignKey = supplier_id, keyOnRelatedModel = id)
        return $this->belongsTo(Truck::class);
    }
    public function driver()
    {
        // belongsTo(RelatedModel, foreignKey = supplier_id, keyOnRelatedModel = id)
        return $this->belongsTo(Driver::class);
    }
}
