<?php

namespace App\Models\Procurement;
use App\Models\Procurement\Inventory\Item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrnItem extends Model
{
    use HasFactory;

    /**
     * GrnItem belongs to Grn.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function grn()
    {
        // belongsTo(RelatedModel, foreignKey = grn_id, keyOnRelatedModel = id)
        return $this->belongsTo(Grn::class);
    }

    /**
     * GrnItem belongs to Item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        // belongsTo(RelatedModel, foreignKey = item_id, keyOnRelatedModel = id)
        return $this->belongsTo(Item::class);
    }
}
