<?php
namespace App\Models\Procurement\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Currency;
use App\Models\Procurement\Inventory\Inventory;
use App\Models\Procurement\Inventory\ItemCategory;
use App\Models\Procurement\Inventory\Brand;
use App\Models\Procurement\Inventory\UnitOfMeasure;
use App\Models\Procurement\PurchaseOrderItem;
use App\Models\Accounting\ChartOfAccount;
use App\Models\Accounting\BudgetItem;
use App\Models\Manufacturing\WorkOrder;
use App\Models\Requisitions\CashRequisitionItem;
class Item extends Model
{
    use HasFactory;
    protected $guarded = ['id'];
    protected $hidden = [
        'created_at',
        'updated_at'
    ];
    // You can have an enum or constants for item types
    const TYPE_INVENTORY = 'product';
    const TYPE_SERVICE = 'service';
    const TYPE_RAW_MATERIAL = 'raw_material';
    const TYPE_SEMI_FINISHED = 'semi_finished';
    const TYPE_FINISHED_GOOD = 'finished_good';

    public function item_category() {
        return $this->belongsTo(ItemCategory::class);
    }
    public function unit_of_measure() {
        return $this->belongsTo(UnitOfMeasure::class);
    }
    public function currency() {
        return $this->belongsTo(Currency::class);
    }
    public function purcahse_orders() {
        return $this->hasMany(PurchaseOrderItem::class);
    }
    public function inventory() {
        return $this->belongsTo(Inventory::class);
    }
    public function chart_of_account() {
        return $this->belongsTo(ChartOfAccount::class);
    }
    public function brand() {
        return $this->belongsTo(Brand::class);
    }
    public function cash_requisition_item() {
        return $this->hasMany(CashRequisitionItem::class);
    }

    public function budget_item() {
        return $this->hasMany(BudgetItem::class);
    }
    public function item_variants()
    {
        return $this->hasMany(ItemVariant::class);
    }
    public function work_order()
    {
        return $this->hasMany(WorkOrder::class);
    }
}
