<?php

namespace App\Models\Sales\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OutGoingStock extends Model
{
    use HasFactory;
    protected $guarded = ['id'];
    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    public function stock() {
        return $this->belongsTo(Stock::class,'stock_id');
    }

    public function department() {
        return $this->belongsTo(Department::class);
    }
}
