<?php
namespace App\Models\Procurement;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Currency;
use App\Models\People\Supplier;
use App\Models\Accounting\Budget\Budget;

use Illuminate\Support\Facades\DB;
class PurchaseOrder extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    protected $hidden = ['created_at', 'updated_at'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($po) {
            $po->purchase_order_no = static::generatePurchaseOrderNumber($po->organisation_id);
        });
       
    }
    private static function generatePurchaseOrderNumber($org_id)
    {
        $date = now()->format('Ymd');

        return DB::transaction(function () use ($org_id) {
            // Use row-level locking to prevent race conditions
            $lastpurchaseorder = static::where('organisation_id', $org_id)
            ->lockForUpdate()->orderBy('id', 'desc')->first();
            //whereDate('created_at', today())->
            $number = $lastpurchaseorder ? intval(substr($lastpurchaseorder->purchase_order_no, -4)) + 1 : 1;

            return 'PO' .  str_pad($number, 4, '0', STR_PAD_LEFT); //$date .
        });
    }

    public function purchase_order_items()
    {
        return $this->hasMany(PurchaseOrderItem::class);
    }
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }
    public function bid()
    {
        return $this->belongsTo(Bid::class);
    }
    public function rfqs()
    {
        return $this->hasMany(RequestForQuotation::class);
    }
    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }
    public function budget()
    {
        return $this->belongsTo(Budget::class);
    }

}
