<?php

namespace App\Models\Procurement;
use App\Models\Accounting\Currency;
use App\Models\Procurement\Inventory\Item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseRequestItem extends Model
{
    use HasFactory;

    /**
     * PurchaseRequestItem belongs to Purchase_requisition.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function purchase_request()
    {
        // belongsTo(RelatedModel, foreignKey = purchase_requisition_id, keyOnRelatedModel = id)
        return $this->belongsTo(PurchaseRequest::class);
    }

    /**
     * PurchaseRequestItem belongs to Item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        // belongsTo(RelatedModel, foreignKey = item_id, keyOnRelatedModel = id)
        return $this->belongsTo(Item::class);
    }
      
    public function currency()
    {
        // belongsTo(RelatedModel, foreignKey = requester_id, keyOnRelatedModel = id)
        return $this->belongsTo(currency::class);
    }

}
