<?php

namespace App\Models\Procurement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RequestForQuotation extends Model
{
    use HasFactory;

    protected $guarded = ['id'];
    protected $hidden = ['created_at','updated_at'];

    public function rfq_items() {
        return $this->hasMany(RequestForQuotationItem::class);
    }
    public function bids() {
        return $this->hasMany(Bid::class);
    }

    public function purchase_request(){
        return $this->belongsTo(PurchaseRequest::class);
    }

}
