<?php

namespace App\Models\Procurement;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupplierInvoice extends Model
{
    use HasFactory;

    protected $guarded = ['id'];
    protected $hidden = ['created_at', 'updated_at'];

    public function supplier() {
        return $this->belongsTo(Supplier::class);
    }
    public function invoiceItems() {
        return $this->belongsTo(SupplierInvoiceItem::class);
    }


    public function payments() {
        return $this->hasMany(InvoicePayment::class);
    }
}
