<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('segments', function (Blueprint $table) {
            $table->id(); 
            $table->uuid('organisation_id');
            $table->string("name");
            $table->enum("segment_type", ['projects', 'departments', 'product','service','geographic', 'industry', 'customer', 'center', 'other'])->unique();
            $table->string("description")->nullable();
            $table->timestamps();  
        });
       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('segments');
    }
};
