<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->string('logo')->nullable();
            $table->text('purchase_requisition_tc')->nullable();
            $table->text('customer_requisition_tc')->nullable();
            $table->text('invoice_tc')->nullable();
            $table->integer('grn_count')->default(0);
            $table->integer('invoice_count')->default(0);
            $table->integer('delivery_note_count')->default(0);
            $table->integer('purchase_requisition_count')->default(0);
            $table->integer('customer_requisition_count')->default(0);
            $table->string('grn_prefix')->nullable();
            $table->string('delivery_note_prefix')->nullable();
            $table->string('invoice_prefix')->nullable();
            $table->string('purchase_requisition_prefix')->nullable();
            $table->string('customer_requisition_prefix')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
