<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('journal_transaction_archives', function (Blueprint $table) {
            $table->id();
            $table->foreignId('journal_transaction_id')->constrained("journal_transactions");
            $table->json('data'); // Store the original data as JSON
            $table->foreignId('fiscal_year_id')->constrained("fiscal_years");
            $table->index('fiscal_year_id');
            $table->timestamps();
        });
      
    }
    
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('journal_transaction_archives');
    }
};
