<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('farmer-collected-weights', function (Blueprint $table) {
            $table->id(); 
            $table->uuid("product"); 
            $table->decimal("quantity", 10,2); 
            $table->date('recorded_date')->default(date("Y-m-d H:i:s"));
            $table->string('description')->nullable(); 
            $table->timestamps(); 
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('farmer-collected-weights');
    }
};
