<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_movements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->constrained()->onDelete('cascade');
            $table->foreignId('from_location_id')->nullable()->constrained('asset_locations')->onDelete('set null');
            $table->foreignId('to_location_id')->nullable()->constrained('asset_locations')->onDelete('set null');
            $table->foreignId('from_asset_assignment_id')->nullable()->constrained('asset_assignments', "id")->onDelete('set null');
            $table->foreignId('to_asset_assignment_id')->nullable()->constrained('asset_assignments', "id")->onDelete('set null');
            $table->date('movement_date');
            $table->string('reason')->nullable(); // Reason for movement
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_movements');
    }
};
