<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('investment_assets', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->integer('investment_asset_type_id');
            $table->integer('tenure');
            $table->integer('tenure_frequency')->comment('1=Month;2=Year')->default(2);
            $table->integer('expense_account_id');
            $table->integer('investment_account_id');
            $table->integer('income_account_id');
            $table->integer('status_id')->default(1);
            $table->integer('created_by');
            $table->integer('organisation_id');
            $table->integer('branch_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investment_assets');
    }
};
