<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asset_incomes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->contrained('assets');
            $table->date('transaction_date');
            $table->decimal('amount', 20, 2);
            $table->text('narrative')->nullable();
            $table->enum('status',[1,0])->default(1);
            $table->integer('reversed_by')->nullable();
            $table->date('reversed_date')->nullable();
            $table->string('reverse_msg')->nullable();
            $table->timestamps();
           
           
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asset_incomes');
    }
};
