<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFmsBorrowingInstallmentPaymentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fms_borrowing_installment_payment', function (Blueprint $table) {
            $table->id();
            $table->foreignId('borrowing_repayment_schedule_id')->nullable();
            $table->foreignId('borrowing_id');
            $table->decimal('paid_interest', 12, 2);
            $table->decimal('paid_principal', 12, 2);
            $table->decimal('principal_over', 15, 2)->nullable();
            $table->decimal('interest_over', 15, 2)->nullable();
            $table->decimal('forgiven_interest', 12, 2);
            $table->date('payment_date');
            $table->text('comment');
            $table->integer('transaction_channel_id')->unsigned();
            $table->integer('status_id')->unsigned();
            $table->integer('prev_payment_status')->unsigned()->nullable();
            $table->dateTime('prev_payment_date')->nullable();
            $table->string('reversal_reason', 200)->nullable();
            $table->foreignId('reversed_by')->nullable();
            $table->string('unique_id', 200);
            $table->integer('created_by')->unsigned();
            $table->integer('modified_by')->unsigned()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fms_borrowing_installment_payment');
    }
}