<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFmsBorrowingRepaymentScheduleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fms_borrowing_repayment_schedule', function (Blueprint $table) {
            $table->id();
            $table->date('repayment_date');
            $table->decimal('interest_amount', 12, 2);
            $table->decimal('principal_amount', 12, 2);
            $table->foreignId('borrowing_id');
            $table->tinyInteger('installment_number');
            $table->decimal('interest_rate', 5, 2);
            $table->integer('repayment_frequency')->nullable();
            $table->tinyInteger('repayment_made_every');
            $table->text('comment');
            $table->date('actual_payment_date');
            $table->tinyInteger('payment_status');
            $table->integer('status_id')->default(1)->nullable();
            $table->integer('created_by');
            $table->integer('modified_by')->nullable();
            $table->string('unique_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fms_borrowing_repayment_schedule');
    }
}