<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_applications', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->foreignId('recruitment_id')->constrained()->onDelete('cascade');
            $table->string('applicant_name');
            $table->string('email')->nullable();
            $table->string('phone', 20)->nullable();
            $table->text('resume')->nullable(); // Could be a URL or file path
            $table->enum('status', ['Applied', 'Interviewed', 'Hired', 'Rejected'])->default('Applied');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('deal_types');
    }
};
