<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payroll_schedule', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->enum('payment_every_after', ['Weekly', 'Two Weeks', "Month", "Quarter"]);
            $table->enum('paytime',['END', "Day"]);
            $table->integer('payday');
            $table->date('first_payroll_date');
            $table->boolean('is_closed')->default(false); // Indicates if payroll for this period is finalized
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payroll_schedule');
    }
};
