<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payslips', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->foreignId('pay_roll_id')->constrained("pay_rolls")->onDelete('cascade');
            $table->decimal('basic_salary', 15, 2);
            $table->decimal('allowances', 15, 2)->nullable();
            $table->decimal('deductions', 15, 2)->nullable();
            $table->decimal('net_salary', 15, 2);
            $table->date('payslip_date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payslips');
    }
};
