<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_payments', function (Blueprint $table) {
            $table->id();
             $table->uuid('organisation_id');// Link to company
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            //$table->foreignId('pay_roll_id')->constrained()->onDelete('cascade');
            $table->decimal('amount_paid', 20, 2);
            $table->string('payment_method'); // E.g., Bank Transfer, Check
            $table->date('payment_date'); // Date of payment
            $table->string('transaction_reference')->nullable(); // Reference number for payment
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_payments');
    }
};
