<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shift_schedules', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->date('shift_date');
            $table->time('shift_start');
            $table->time('shift_end');
            $table->string('shift_type'); // e.g., Morning, Evening, Night
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shift_schedules');
    }
};
