<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        
        Schema::create('work_orders', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->string("order_number")->nullable();
            $table->foreignId('production_line_id')->constrained('production_lines')->onDelete('cascade');
            $table->date('actual_start_date');
            $table->date('actual_end_date')->nullable();
            $table->date('planned_start_date');
            $table->date('planned_end_date');
            $table->string('description')->nullable();
            $table->enum('status', ['pending', 'in_progress', 'completed'])->default('pending');
            $table->timestamps();
        });
        Schema::create('work_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('work_order_id')->constrained('work_orders')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->decimal('quantity', 8, 2);
            $table->string('notes')->nullable();
            $table->timestamps();
        });
        
        Schema::create('work_order_tasks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('work_order_id')->constrained('work_orders')->onDelete('cascade');
            $table->string('task_name');
            $table->foreignId('assigned_to');
            $table->enum('status', ['pending', 'in_progress', 'completed'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('work_orders');
        Schema::dropIfExists('work_order_tasks');
    }
};
