<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('request_for_quotation_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('request_for_quotation_id')->constrained("request_for_quotations");
            $table->foreignId('item_id')->constrained("items");
            $table->string('quantity');
            $table->string('specifications')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('request_for_quotation_items');
    }
};