<?php 
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bids', function (Blueprint $table) {
            $table->id();
            $table->string('bid_no');
            $table->foreignId('request_for_quotation_id')->constrained("request_for_quotations");
            $table->foreignId('supplier_id')->constrained("suppliers");
            $table->datetime('submmitted_at');
            $table->decimal('total_cost',18,2);
            $table->decimal('currency_id')->constrained("currencies");
            $table->date('submission_deadline');
            $table->integer('delivery_time');
            $table->string('bid_document')->nullable();
            $table->timestamps();
            $table->softDeletes(); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bids');
    }
};