<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bid_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId("bid_id")->constraint("bids");
            $table->foreignId('request_for_quotation_item_id')->constrained('request_for_quotation_items');
            //$table->foreignId('item_id')->constrained('request_for_quotation_items');
            $table->decimal("unit_price", 18,2);
            $table->string("quantity");
            $table->decimal("total_price", 18,2)->storedAs('quantity * unit_price');
            $table->foreignId('currency_id')->constrained('currencies');
            $table->integer("delivery_time");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bid_items');
    }
};
