<?php


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->id();
            $table->string('purchase_order_no');
            $table->uuid('organisation_id');
            $table->foreignId('bid_id')->nullable()->constrained('bids')->nullOnDelete();
            $table->foreignId('supplier_id')->nullable()->constrained('suppliers');
            $table->date('issue_date');
            $table->date('develivery_date')->nullable();
            $table->decimal('total_amount',20,2);
            $table->foreignId('currency_id')->constrained('currencies');
            $table->enum("status", ['pending','confirmed','delivered','canceled'])->default("pending");
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_orders');
    }
};
