<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number');
            $table->uuid('organisation_id');
            $table->foreignId('purchase_order_id')->constrained("purchase_orders");
            $table->foreignId('supplier_id')->constrained("suppliers");
            $table->date('invoice_date');
            $table->decimal('total_amount', 18, 2);
            $table->foreignId('currency_id')->constrained('currencies');
            $table->string('invoice_attachment')->nullable();
            $table->enum('status', ['unpaid', 'paid'])->default('unpaid');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_invoices');
    }
};
