<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('supplier_invoice_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId("supplier_invoice_id")->constrained("supplier_invoices");
            $table->foreignId("item_id")->constrained("items");
            $table->integer("quantity");
            $table->decimal("unit_price", 18,2);
            $table->decimal("total_price", 18,2)->storedAs('quantity * unit_price');
            $table->foreignId("currency_id")->constrained("currencies");
            $table->text("notes")->nullable();  
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplier_invoice_items');
    }
};
