<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
          // Return to vendor
          Schema::create('grn_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('grn_id')->constrained("grns")->onDelete('cascade');
            $table->foreignId('item_id')->constrained("suppliers")->onDelete('cascade');
            $table->integer('received_quantity');
            $table->enum('inspection_status', ['pending','approved','rejected'])->default("pending");
            $table->foreignId('inspected_by')->nullable();
            $table->string('remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grn_items');
    }
};
