<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{ /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inventories', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");//->constrained("organisations");
            $table->foreignId("item_id")->constrained("items");
            $table->foreignId('supplier_id')->nullable()->constrained("suppliers")->onDelete('set null');
            $table->string("ref_id")->nullable();//Can refer to grn_item_id 
            $table->foreignId("warehouse_id")->constrained("warehouses");  //Store where goods are
            $table->dateTime('received_date')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->decimal('quantity', 10,2)->default(0);
            $table->decimal('damaged_quantity',10,2)->default(0); // For damaged stock report
            $table->integer('reorder_level')->default(10); // For reorder report
            $table->integer('on_backorder')->default(0); // For backorder report
            $table->date('expiry_date')->nullable(); // For product expiry report
            $table->string('reason_for_damage')->nullable(); // For damaged stock report
            $table->string('unique_id')->nullable(); // For
            $table->timestamps();
            //
        });

         Schema::create('stock_movements', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->foreignId('item_id')->constrained("items")->onDelete('cascade');
            $table->foreignId('inventory_id')->constrained("inventories")->onDelete('cascade');
            $table->enum('type', ['sale', 'purchase', 'transfer_in', 'transfer_out','return', 'writeoff', 'manufacturing', 'donations', 'consumption','milling'])->default("purchase");
            $table->decimal('quantity', 10,2);
            $table->foreignId('warehouse_id')->nullable()->constrained('warehouses')->onDelete('set null'); 
            $table->enum('category', ['in', 'out']);   
            $table->string('picked_by')->nullable();
            $table->string('received_by')->nullable();
            $table->string('delivered_by')->nullable();
            $table->string('delivery_remarks')->nullable();
            $table->dateTime('movement_date')->default(\DB::raw('CURRENT_TIMESTAMP'));
            $table->string("movement_reason")->nullable();
            $table->string("remarks")->nullable();
            $table->enum('status', ['pending', 'received', "moved", 'reversed'])->default("received");
            $table->string('unique_id');
            $table->timestamps();
        });
        // Supplier Orders (optional for Supplier Performance Report)
        Schema::create('supplier_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('supplier_id')->constrained("suppliers")->onDelete('cascade');
            $table->date('order_date');
            $table->integer('delivery_time')->nullable(); // In days, for supplier performance report
            $table->decimal('fulfillment_accuracy', 5, 2)->nullable(); // For supplier performance report
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventories');
        Schema::dropIfExists('stock_movements');
        Schema::dropIfExists('supplier_orders');
       // Schema::dropIfExists('returntovendors');
    }
};
