<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Represents the services provided during an activity (e.g., training, health services, consultations).
     */
    public function up(): void
    {
        Schema::create('activity_services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('activity_id')->constrained("activities");
            $table->string('service_name');
            $table->string('cost');
            $table->text('description')->nullable();
            $table->foreignId('age_group_id')->nullable()->constrained("age_groups");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_services');
    }
};
