<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('goods_received_notes', function (Blueprint $table) {
            $table->id();
            $table->string("goods_received_note_no");
            $table->date('date_received');
            $table->time('time_received');
            $table->foreignId('sales_order_id')->constrained("sales_orders");
            $table->foreignId('goods_dispatched_note_id')->nullable();
            $table->string('carrier')->nullable();
            $table->string('delivery_person');
            $table->string('shipment_tracking_number')->nullable();
            $table->string('delivery_location')->nullable();
            $table->foreignId('truck_id')->nullable();
            $table->foreignId('driver_id')->nullable();
            $table->integer('verified_by')->nullable();
            $table->date('verification_date')->nullable();
            $table->integer('approved_by')->nullable();
            $table->date('approval_date')->nullable();
            $table->string('remarks')->nullable();
            $table->enum('status', ['pending', 'approved', 'verified','closed'])->nullable('pending');
            $table->foreignId("credit_note_id")->nullable();
            $table->boolean('discrepancy_flag')->default(false);
            $table->timestamps();
        });
        Schema::create('goods_received_note_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('goods_received_note_id')->constrained("goods_received_notes");
            $table->foreignId('item_id')->constrained("items");
            $table->integer('quantity');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('goods_received_notes');
        Schema::dropIfExists('goods_received_note_items');
    }
};
