<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sales_invoices', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->string('sales_invoice_no');
            $table->string('issue_date');  
            $table->string('due_date'); 
            $table->enum('status',['unpaid', 'paid', 'overdue', 'partially paid'])->default('unpaid');
            $table->foreignId('sales_order_id')->constrained("sales_orders");
            $table->foreignId('goods_received_note_id')->nullable()->constrained("goods_received_notes");
            $table->foreignId('goods_dispatched_note_id')->nullable()->constrained("goods_dispatched_notes");
            $table->foreignId('salesperson_id')->nullable();
            $table->string('payment_terms')->nullable();
            $table->foreignId("customer_id")->nullable();
            $table->foreignId("customer_name")->nullable();
            $table->foreignId("customer_address")->nullable();
            $table->foreignId("customer_contact")->nullable();
            $table->string('vat')->nullable();
            $table->decimal('total_amount', 20,3);
            $table->decimal('tax_amount', 20,3)->default(0);
            $table->decimal('discount_amount', 20,3)->nullable();
            $table->decimal('shipping_fee', 20,3)->nullable();
            $table->decimal('amount_due', 20,3)->nullable();
            $table->decimal('amount_paid', 20,3)->nullable();
            $table->decimal('balance_due', 20,3)->nullable();
            $table->foreignId('currency_id')->constrained('currencies');
            $table->timestamps();
        });
        Schema::create('sales_invoice_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_invoice_id')->constrained('sales_invoices');
            $table->foreignId('item_id')->constrained('items');
            $table->integer('quantity')->nullable();
            $table->decimal('unit_price', 10,2);
            $table->decimal('discount', 10,2)->nullable();
            $table->decimal('tax_rate', 10,2)->nullable();           
            $table->decimal('total_price',10,2)->storedAs('quantity * unit_price');
            $table->foreignId('currency_id')->constrained('currencies');
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales_invoices');
        Schema::dropIfExists('sales_invoice_items');
    }
};
