<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCreditNotesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('credit_notes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sales_invoice_id')->constrained('sales_invoices');
            $table->date('credit_mote_date');
            $table->decimal('credit_amount',10,2);
            $table->foreignId('currency_id')->constrained('currencies');
            $table->text('reason');
            $table->timestamps();
        });
        Schema::create('credit_note_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('credit_note_id')->constrained('credit_notes');
            $table->foreignId('item_id')->constrained('items');
            $table->integer('quantity')->nullable();
            $table->decimal('unit_price', 10,2);
            $table->foreignId('currency_id')->constrained('currencies');
            $table->decimal('total_price',10,2)->storedAs('quantity * unit_price');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('credit_notes');
        Schema::dropIfExists('credit_note_items');
    }
}
