<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       
       
        Schema::create('sales', function (Blueprint $table) {
            $table->id();
            $table->string('customer_id')->nullable();
            $table->foreignId('warehouse_id')->nullable()->constained("warehouses");
            $table->string('customer_name')->nullable();
            $table->foreignId('cashier_id')->nullable();
            $table->string('cashier_name')->nullable();
            $table->decimal('total_amount', 10, 2);
            $table->decimal('discount', 10, 2)->default(0);
            $table->enum('payment_status', ['paid', 'pending', 'partial', 'cancelled'])->default('pending');
            $table->foreignId('payment_method_id')->constrained("payment_methods");
            $table->datetime('sale_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string("unique_id")->nullable();
            $table->timestamps();
        });

        Schema::create('sales_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_id')->constrained('sales')->onDelete('cascade');
            $table->foreignId('item_id')->constrained('items')->onDelete('cascade');
            $table->integer('quantity');
            $table->decimal('unit_price', 10, 2);
            $table->decimal('subtotal', 10, 2);
            $table->decimal('tax', 10, 2)->default(0);
            $table->decimal('discount', 10, 2)->default(0);
            $table->string("unique_id")->nullable();
            $table->timestamps();
        });

        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_id')->nullable()->constrained('sales')->onDelete('cascade');
            $table->foreignId('sales_invoice_id')->nullable()->constrained('sales_invoices')->onDelete('cascade');
            $table->decimal('amount_paid', 10, 2);
            $table->enum('payment_method', ['cash', 'card', 'mobile_money', 'credit']);
            $table->enum('status', ['success', 'failed', 'pending'])->default("success");
            $table->string('transaction_reference')->nullable();
            $table->datetime('payment_date')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string("unique_id")->nullable();
            $table->timestamps();
        });
      
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sales');
        Schema::dropIfExists('sales_items');
        Schema::dropIfExists('payments');
        Schema::dropIfExists('payment_methods');
    }
};
