<?php

namespace App\Models\Procurement\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    use HasFactory;
    protected $guarded = ['id'];
    protected $hidden = [
        'created_at',
        'updated_at'
    ];
    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    /**
     * Get the warehouse associated with the stock movement.
     */
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    /**
     * Get the user who performed the stock movement.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
