<?php

namespace App\Models\Procurement;
use App\Models\User;
use App\Models\Accounting\Currency;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class PurchaseRequest extends Model
{
    use HasFactory,softDeletes;
    public $guarded = ['id'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($purchase_request) {
            $purchase_request->purchase_request_no = static::generatPRN($purchase_request->organisation_id);
        });
        // static::deleting(function ($property) {
        //     $property->features()->delete();
        //     $property->images()->delete();
        // });
    }
    private static function generatPRN($org_id)
    {
        $date = now()->format('Ymd');

        return DB::transaction(function () use ($org_id) {
            // Use row-level locking to prevent race conditions
            $last_prn = static::where('organisation_id', $org_id)
            ->lockForUpdate()
            ->orderBy('id', 'desc')
            //->whereDate('created_at', today())
            ->lockForUpdate()
            ->first();
            $number = $last_prn ? intval(substr($last_prn->purchase_request_no, -4)) + 1 : 1;

            return 'PRN-' .  str_pad($number, 6, '0', STR_PAD_LEFT); //$date .
        });
    }
    /**
     * PurchaseRequest has many Items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function purchase_request_items()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = PurchaseRequest_id, localKey = id)
        return $this->hasMany(PurchaseRequestItem::class,'purchase_request_id');
    }
    public function purchase_request_approved_items()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = PurchaseRequest_id, localKey = id)
        return $this->hasMany(PurchaseRequestApprovedItem::class,'purchase_request_id');
    }
    public function rfqs()
    {
        return $this->hasMany(RequestForQuotation::class);
    }

    /**
     * PurchaseRequest belongs to Requester.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function requester()
    {
        // belongsTo(RelatedModel, foreignKey = requester_id, keyOnRelatedModel = id)
        return $this->belongsTo(User::class,'requested_by');
    }

    /**
     * PurchaseRequest belongs to Proccessor.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function reviewer()
    {
        // belongsTo(RelatedModel, foreignKey = proccessor_id, keyOnRelatedModel = id)
        return $this->belongsTo(User::class,'reviewed_by');
    }
    public function approver()
    {
        // belongsTo(RelatedModel, foreignKey = proccessor_id, keyOnRelatedModel = id)
        return $this->belongsTo(User::class,'approved_by');
    }
    public function currency()
    {
        // belongsTo(RelatedModel, foreignKey = proccessor_id, keyOnRelatedModel = id)
        return $this->belongsTo(Currency::class,'approved_by');
    }
}
