<?php

namespace App\Models\Procurement;
use App\Models\Procurement\Inventory\Item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RequestForQuotationItem extends Model
{
    use HasFactory;
    protected $guarded = ['id'];
    protected $hidden = ['created_at','updated_at'];


    /**
     * RequestForQuotationItem belongs to Item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        // belongsTo(RelatedModel, foreignKey = item_id, keyOnRelatedModel = id)
        return $this->belongsTo(Item::class);
    }
    public function request_for_quotation()
    {
        return $this->belongsTo(RequestForQuation::class);
    }
    public function bid_item()
    {
        return $this->hasOne(BidItem::class);
    }
}
