<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('staff', function (Blueprint $table) {
            $table->id();
            $table->foreignId("user_id");//->constrained("users");
            $table->string('spouse_name')->nullable();
            $table->string('place_of_birth')->nullable();
            $table->integer('no_of_children')->nullable();
            $table->string('nssf_no')->nullable();
            $table->string('tin_no')->nullable();
            $table->string('bank')->nullable();
            $table->string('account_no')->nullable();
            $table->string('national_id_no')->nullable();
            $table->string('passport_no')->nullable();
            $table->string('job_title')->nullable();
            $table->string('work_id')->nullable();
            $table->decimal('salary',10,2)->nullable();
            $table->date('date_of_first_appointment')->nullable();
            $table->date('date_of_present_appointment')->nullable();
            $table->integer('department_id')->constrained("departments")->nullable();
            $table->string('duty_station')->nullable();
            $table->string('social_membership')->nullable();
            $table->string('highest_qualification')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('staff');
    }
};
