<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('account_sub_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description');
            $table->integer('code')->unique();
            $table->uuid('organisation_id')->nullable();  
            $table->foreignId("account_category_id")->constrained("account_categories");    
            $table->boolean('is_system_created')->default(0)->comment('This is to avoid deleting account which are prepacked in the system');
            $table->boolean('is_adjustment')->default(0)->comment('This is to avoid deleting account which are prepacked in the system');
            $table->foreignId('parent_id')->nullable()->constrained("account_sub_categories")->onDelete('set null');
            $table->index(['account_category_id']);
            $table->index(['account_category_id', 'organisation_id']);
            $table->enum('cash_flow_type', ['Operating', 'Investing', 'Financing'])->nullable(); 
            $table->softDeletes();
            $table->timestamps();
            
        });
    }


 
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('account_sub_categories');
    }
};
