<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('chart_of_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();;
            $table->text('description')->nullable();
            $table->uuid("organisation_id");
            $table->uuid('branch_id')->nullable();
            $table->foreignId("account_sub_category_id")->constrained("account_sub_categories"); 
            $table->foreignId("parent_id")->nullable()->constrained("chart_of_accounts")->onDelete('set null');
            $table->enum('is_contra', [1, 0])->default(0); 
            $table->enum("manual_entry",[1,0])->default(0);
            $table->enum("is_sys",[1,0])->default(0);
            $table->index(['organisation_id']);
            $table->index(['branch_id']);
            $table->index(['account_sub_category_id']);
            $table->index(['organisation_id', 'branch_id']);
            $table->index(['organisation_id', 'account_sub_category_id'], 'coa_organisation_branch_sub_category_index');
            $table->softDeletes();
            $table->timestamps();
        });
    }


 
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('chart_of_accounts');
    }
};
