<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDailyAccountSummationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('daily_account_summations', function (Blueprint $table) {
            $table->id();
            $table->foreignId("chart_of_account_id")->constrained("chart_of_accounts");
            $table->foreignId("account_sub_category_id")->nullable()->constrained("account_sub_categories");
            $table->foreignId("fiscal_year_id")->constrained("fiscal_years");
            $table->decimal('amount', 30, 2)->default(0); //Saved in base currency
            $table->decimal('base_currency_amount', 25, 4);
            $table->decimal("currency_rate",15,4)->nullable();
            $table->date("transaction_date");
            $table->softDeletes();
            $table->timestamps();
        });
    }


 
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('daily_account_summations');
    }
}
