<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assets', function (Blueprint $table) {
            $table->id();
            $table->uuid("organisation_id");
            $table->string('name');
             $table->string('identity_no')->nullable();
            $table->foreignId('asset_category_id')->constrained("asset_categories");
            $table->date('purchase_date');
            $table->decimal('purchase_cost', 18, 2);
            $table->decimal('current_value', 18, 2)->nullable(); // Updated value after depreciation
            $table->decimal('accumulated_depreciation', 18, 2)->default(0); // Updated value after depreciation
            $table->string('supplier')->nullable();
            $table->date('date_put_to_use');
            
            $table->foreignId('asset_account_id')->constrained("chart_of_accounts");
            $table->integer('depreciation_account_id')->nullable();
            $table->integer('depreciation_loss_account_id')->nullable();
            $table->integer('depreciation_gain_account_id')->nullable();
            $table->integer('expense_account_id')->nullable();
            $table->enum('depreciation_method', ['straight_line', 'declining_balance'])->default('straight_line');
            $table->decimal('depreciation_rate', 5, 2)->default(0); // Percentage per year
            $table->integer('depreciation_calculation_frequency')->nullable();
            $table->integer('income_account_id')->nullable();
            $table->integer('appreciation_account_id')->nullable();
            $table->integer('appreciation_loss_account_id')->nullable();

            $table->integer('appreciation_rate')->nullable();
            $table->integer('salvage_value')->nullable();//also know as resideual value
            $table->integer('expected_age')->default(0);
            $table->string('description')->nullable();
            $table->integer('status_id')->default(1);
            $table->integer('created_by')->nullable();
            $table->integer('modified_by')->nullable();
            $table->integer('branch_id')->nullable();
            $table->integer('useful_life')->nullable(); // In years
            $table->date('warranty_expiry_date')->nullable();
            $table->enum('status',['active','inactive', 'disposed','maintenance','inuse'])->default('active'); // e.g., 'active', 'inactive', 'disposed'
            $table->timestamps();
        });

        Schema::create('asset_insurance', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->contrained("assets");
            $table->string('policy_no');
            $table->string('insurer');
            $table->string('insurance_type');// e.g comprehensive
            $table->decimal('insured_value', 15, 4);
            $table->date("start_date")->nullable();
            $table->date("end_date")->nullable();
            $table->timestamps();
        });
        Schema::create('asset_attachments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->contrained("assets");
            $table->string('description')->nullable();
            $table->string('attachment');
            $table->timestamps();
        });
        Schema::create('asset_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->contrained("assets");
            $table->foreignId('user_id');
            $table->string('description')->nullable();
            $table->date("start_date")->nullable();
            $table->date("end_date")->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->enum("status", ['active', 'returned','damaged'])->nullable();
            $table->timestamps();
        });
        Schema::create('asset_maintenances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->constrained()->onDelete('cascade');
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->string('description');
            $table->decimal('cost', 18, 2)->nullable();
            $table->string('service_provider_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assets');
        Schema::dropIfExists('asset_insurance');
        Schema::dropIfExists('asset_attachments');
        Schema::dropIfExists('asset_assignments');
        Schema::dropIfExists('asset_maintenances');
    }
};
