<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('depreciations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->contrained("assets");
            $table->decimal('amount',20,2);
            $table->decimal('accumulated_depreciation',20,2)->default(0);
            $table->datetime('depreciation_date');
            $table->integer('fiscal_year_id');
            $table->string('narrative')->nullable();
            $table->string('month')->nullable();
            $table->timestamps();
        });
    }
   
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('depreciations');
    }
};
