<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        
        Schema::create('requisition_approval_levels', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->foreignId('branch_id')->nullable();
            $table->string('name');
            $table->enum('level', [1,2,3,4]); 
            $table->enum('isactive', [true, false])->default(true);
            $table->enum('mandate', [1, 2])->default(1);
            $table->string("description")->nullable();
            $table->unique(['level', 'organisation_id']);
            $table->timestamps();
            $table->softDeletes();
        });
        Schema::create('approvers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('requisition_approval_level_id')->constrained("requisition_approval_levels");
            $table->foreignId('employee_id')->constrained("employees");
            $table->string("approver_names")->nullable();
            $table->string("approver_email")->nullable();
            $table->enum('role', ['approver', 'reviewer']);
            $table->string("description")->nullable();
            //$table->unique(['requisition_approval_level_id', 'role'], 'unique_level_role');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('requisition_approval_levels');
        Schema::dropIfExists('approvers');
    }
};