<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cash_requisitions', function (Blueprint $table) {
            $table->id();
            $table->uuid('organisation_id');
            $table->string(column: 'requisition_no');
            $table->foreignId('requester_id')->contrained("employees", "id");
            $table->string('requested_by_name')->nullable();
            $table->string('title')->nullable();
            $table->decimal('total_amount', 20, 2)->nullable();
            $table->decimal('approved_total_amount', 20, 2)->default(0);
            $table->foreignId('currency_id')->nullable();
            $table->text('purpose')->nullable();
            $table->foreignId('current_approval_level')->default(1);
            $table->enum('status',["pending", "reviewed","partial_aproval", "approved", "rejected"])->default("pending");          
            $table->date('date_expected')->nullable();
            $table->foreignId('branch_id')->nullable();
            $table->foreignId('segment_id')->nullable();
            $table->foreignId('department_id')->nullable();
            $table->uuid('budget_id')->nullable();
            $table->foreignId('project_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('budget_id')->references('id')->on('budgets')->cascadeOnDelete();
        });
        Schema::create('cash_requisition_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cash_requisition_id')->constrained("cash_requisitions");
            $table->uuid('budget_item_id')->nullable();
            $table->foreignId('requested_item_id')->constrained("chart_of_accounts", "id");
            $table->string('item_name');
            $table->decimal('unit_cost', 20, 2);
            $table->decimal('quantity',20,2);
            $table->decimal('total_cost', 20, 2)->storedAs('quantity * unit_cost');
            $table->decimal('approved_quantity', 20, 2)->default(0);
            $table->decimal('approved_unit_cost', 20, 2)->default(0);
            $table->decimal('approved_total_cost', 20, 2)->storedAs('approved_quantity * approved_unit_cost');
            $table->enum('status', ['pending','reviewed',  'approved', 'rejected'])->default('pending'); // Approval status
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('budget_item_id')->references('id')->on('budget_items')->cascadeOnDelete();
        });
        Schema::create('cash_requisition_approval_workflows', function (Blueprint $table) {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            $table->id();
            $table->foreignId('cash_requisition_id');
            $table->foreignId('approver_id');
            $table->string('approver_name')->nullable();
            $table->foreignId('level');
            $table->enum("status", ['pending', 'reviewed','approved', 'rejected'])->default('pending');
            $table->string('remarks')->nullable();
            $table->timestamps();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        });
        Schema::create('requisition_quantity_changes', function (Blueprint $table) {
            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            $table->id();
            $table->foreignId('cash_requisition_item_id');
            $table->foreignId('changed_by');// the approver who changed the quantity
            $table->string('changer_name')->nullable();
            $table->integer('old_quantity');
            $table->integer('new_quantity');
            $table->string('change_reason')->nullable();
            $table->timestamps();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cash_requisitions');
        Schema::dropIfExists('cash_requisition_items');
        Schema::dropIfExists('cash_requisition_approval_workflow');
        Schema::dropIfExists('cash_requisition_quantity_changes');
    }
};