<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
     
        Schema::create('cash_requisition_item_approvals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cash_requisition_id')->constrained();
            $table->foreignId('cash_requisition_item_id')->constrained();
            $table->foreignId('approval_level_id')->constrained("requisition_approval_levels");
            $table->foreignId('approver_id');
            $table->enum('action', ['approved', 'rejected']);
            $table->integer('approved_quantity')->nullable();
            $table->decimal('approved_amount', 20, 2)->default(0);
            $table->text('comments')->nullable();
            $table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cash_requisition_item_approvals');
    }
};